/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.notifs.CDCBaseNotification;
import com.webhook.util.CDCTables;
import com.webhook.util.ColumnNameChanger;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class OrderChangeField
extends BaseChangeFieldGenerator {
    OrderChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        this.changedFields = ColumnNameChanger.getFakedColumnsPayload(payload, (CDCTables)changedTable);
        this.addOrderDtlData();
        this.addOrderData();
    }

    private void addOrderDtlData() {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT ROUND(W.[EXIST], 3) [fewTak], ROUND(V.[EXIST], 3) [fewSpd], A.Exist few \n FROM W_ShowArticleForSearch_Big W \n LEFT JOIN W_GETEXISTARTICLE V ON V.A_CODE = W.A_CODE \n JOIN Article A ON V.A_CODE = A.A_CODE WHERE W.A_CODE = ?", new Object[]{ConvertStr.decrypt((String)((String)this.changedFields.get("productCode")))});
        if (!rs.next()) {
            return;
        }
        this.changedFields.put("few", rs.getDouble("few"));
        this.changedFields.put("fewTak", rs.getDouble("fewTak"));
        this.changedFields.put("fewSpd", rs.getDouble("fewSpd"));
    }

    private void addOrderData() {
        StringBuilder cols = new StringBuilder();
        for (int i = 0; i < CDCTables.ORDER.getCols().length; ++i) {
            cols.append(CDCTables.ORDER.getCols()[i]);
            if (i == CDCTables.ORDER.getCols().length - 1) continue;
            cols.append(",");
        }
        String sql = "SELECT " + cols + " FROM RqTitle WHERE RqIndex = " + ConvertStr.decrypt((String)((String)this.changedFields.get("orderId")));
        Map<String, Boolean> order = new HashMap();
        Map data = new HashMap();
        try {
            data = this.getJdbcTemplate().queryForMap(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!data.isEmpty()) {
            order = ColumnNameChanger.getFakedColumnsPayload(data, (CDCTables)CDCTables.ORDER);
            order.put("orderId", (Boolean)this.changedFields.get("orderId"));
            order.put("isOrderDeleted", false);
        } else {
            order.put("ErpCode", (Boolean)this.changedFields.get("orderId"));
            order.put("isOrderDeleted", true);
        }
        this.changedFields.put("order", order);
    }

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        try {
            CDCBaseNotification toAddNotification = null;
            ArrayList<CDCBaseNotification> orderNotifications = new ArrayList<CDCBaseNotification>();
            for (CDCBaseNotification notification : notifications) {
                if (!notification.getChangedTableName().equalsIgnoreCase("dbo.RqDetail")) continue;
                orderNotifications.add(notification);
            }
            HashSet deletedRows = new HashSet();
            HashSet createdRows = new HashSet();
            ArrayList<Map> commonItems = new ArrayList<Map>();
            for (CDCBaseNotification notification : orderNotifications) {
                if (notification.getOperation() == Envelope.Operation.DELETE) {
                    deletedRows.addAll(notification.getAllChangedRows());
                    continue;
                }
                if (notification.getOperation() != Envelope.Operation.CREATE) continue;
                createdRows.addAll(notification.getAllChangedRows());
            }
            for (Map created : createdRows) {
                for (Map deleted : deletedRows) {
                    if (!created.get("orderId").equals(deleted.get("orderId")) || !created.get("productCode").equals(deleted.get("productCode"))) continue;
                    commonItems.add(created);
                }
            }
            if (!commonItems.isEmpty()) {
                for (CDCBaseNotification notification : orderNotifications) {
                    for (Map item : commonItems) {
                        notification.getAllChangedRows().removeIf(toDelete -> toDelete.get("orderId").equals(item.get("orderId")) && toDelete.get("productCode").equals(item.get("productCode")));
                    }
                }
                toAddNotification = new CDCBaseNotification(((CDCBaseNotification)orderNotifications.get(0)).getParser(), Envelope.Operation.UPDATE);
                toAddNotification.setChangedTableName(CDCTables.ORDER_DETAIL.getFinalChangeTableName());
                toAddNotification.getAllChangedRows().addAll(commonItems);
                orderNotifications.add(toAddNotification);
            }
            this.fixOrderStructure(orderNotifications);
            ArrayList<CDCBaseNotification> baseNotifications = new ArrayList<CDCBaseNotification>();
            baseNotifications.add(toAddNotification);
            return baseNotifications;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fixOrderStructure(List<CDCBaseNotification> orderNotifications) {
        for (CDCBaseNotification notification : orderNotifications) {
            Map<Object, List<Map>> groupBy = notification.getAllChangedRows().stream().collect(Collectors.groupingBy(map -> map.get("orderId")));
            notification.getAllChangedRows().clear();
            groupBy.forEach((orderId, data) -> {
                HashMap<String, Object[]> order = new HashMap<String, Object[]>();
                ArrayList dtlArray = new ArrayList();
                data.forEach(created -> {
                    order.putAll((Map)created.get("order"));
                    HashMap dtl = new HashMap(created);
                    dtl.remove("order");
                    dtlArray.add(dtl);
                });
                order.put("dtl", dtlArray.toArray());
                notification.getAllChangedRows().add(order);
            });
        }
    }
}

